package com.agilex.healthcare.veteranappointment.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import gov.va.vamf.scheduling.direct.serializer.XSSProtectionDeserializer;
import gov.va.vamf.scheduling.direct.serializer.XSSProtectionSerializer;

import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
public class JSONJAXBContextResolver implements ContextResolver<ObjectMapper> {

    private ObjectMapper objectMapper;

    public JSONJAXBContextResolver() {
        AnnotationIntrospector jaxbAnnotationIntrospector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        AnnotationIntrospector jacksonAnnotationIntrospector = new JacksonAnnotationIntrospector();

        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(String.class, new XSSProtectionDeserializer());
        simpleModule.addSerializer(String.class, new XSSProtectionSerializer());

        objectMapper = new ObjectMapper()
                .configure(SerializationFeature.INDENT_OUTPUT, true)
                .configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)
                .configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
                .configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false)
                .setSerializationInclusion(JsonInclude.Include.NON_NULL)
                .setAnnotationIntrospectors(jacksonAnnotationIntrospector, jaxbAnnotationIntrospector)
                .registerModule(simpleModule);
    }

    @Override
    public ObjectMapper getContext(Class<?> type) {
        return objectMapper;
    }

}
